/*
 * Decompiled with CFR 0.152.
 */
public final class RaycastCollision {
    public final Raycast raycast;
    public final abw world;
    private final Object object_hit;
    public int block_hit_x;
    public int block_hit_y;
    public int block_hit_z;
    public float block_hit_offset_x;
    public float block_hit_offset_y;
    public float block_hit_offset_z;
    public int block_hit_metadata;
    public int neighbor_block_x;
    public int neighbor_block_y;
    public int neighbor_block_z;
    public final EnumFace face_hit;
    public final atc position_hit;

    public RaycastCollision(Raycast raycast, nn entity_hit, AABBIntercept intercept) {
        this.raycast = raycast.setHasProducedCollisions();
        this.world = entity_hit.q;
        this.object_hit = entity_hit;
        this.face_hit = intercept.face_hit;
        this.position_hit = intercept.position_hit;
    }

    public RaycastCollision(Raycast raycast, int x2, int y2, int z2, EnumFace face_hit, atc position_hit) {
        this.raycast = raycast.setHasProducedCollisions();
        this.world = raycast.getWorld();
        aqz block = this.world.getBlock(x2, y2, z2);
        this.object_hit = block;
        this.block_hit_metadata = this.world.h(x2, y2, z2);
        this.block_hit_x = x2;
        this.block_hit_y = y2;
        this.block_hit_z = z2;
        this.face_hit = face_hit;
        this.position_hit = position_hit.b.a(position_hit.c, position_hit.d, position_hit.e);
        this.block_hit_offset_x = (float)(position_hit.c - (double)x2);
        this.block_hit_offset_y = (float)(position_hit.d - (double)y2);
        this.block_hit_offset_z = (float)(position_hit.e - (double)z2);
        if (face_hit != null) {
            if (face_hit == EnumFace.BOTTOM) {
                --y2;
            } else if (face_hit == EnumFace.TOP) {
                ++y2;
            } else if (face_hit == EnumFace.NORTH) {
                --z2;
            } else if (face_hit == EnumFace.SOUTH) {
                ++z2;
            } else if (face_hit == EnumFace.WEST) {
                --x2;
            } else if (face_hit == EnumFace.EAST) {
                ++x2;
            }
            this.neighbor_block_x = x2;
            this.neighbor_block_y = y2;
            this.neighbor_block_z = z2;
        }
    }

    public RaycastCollision(nn entity_hit) {
        this.world = entity_hit.q;
        this.object_hit = entity_hit;
        this.face_hit = null;
        this.position_hit = entity_hit.getCenterPoint();
        this.raycast = new Raycast(this.world, this.position_hit, this.position_hit);
    }

    public boolean isBlock() {
        return this.object_hit instanceof aqz;
    }

    public boolean isSolidBlock() {
        aqz block = this.getBlockHit();
        return block != null && block.isSolid(this.block_hit_metadata);
    }

    public boolean isLiquidBlock() {
        aqz block = this.getBlockHit();
        return block != null && block.isLiquid();
    }

    public boolean isBlockAt(int x2, int y2, int z2) {
        if (!this.isBlock()) {
            return false;
        }
        return x2 == this.block_hit_x && y2 == this.block_hit_y && z2 == this.block_hit_z;
    }

    public boolean isEntity() {
        return this.object_hit instanceof nn;
    }

    public aqz getBlockHit() {
        if (this.isBlock()) {
            return (aqz)this.object_hit;
        }
        return null;
    }

    public int getBlockHitID() {
        if (this.isBlock()) {
            return this.getBlockHit().cF;
        }
        return 0;
    }

    public akc getBlockHitMaterial() {
        if (this.isBlock()) {
            return this.getBlockHit().cU;
        }
        return null;
    }

    public aqz getNeighborOfBlockHit() {
        if (this.isBlock()) {
            return this.world.getBlock(this.neighbor_block_x, this.neighbor_block_y, this.neighbor_block_z);
        }
        return null;
    }

    public int getNeighborOfBlockHitID() {
        if (this.isBlock()) {
            return this.world.a(this.neighbor_block_x, this.neighbor_block_y, this.neighbor_block_z);
        }
        return 0;
    }

    public int getNeighborOfBlockHitMetadata() {
        if (this.isBlock()) {
            return this.world.h(this.neighbor_block_x, this.neighbor_block_y, this.neighbor_block_z);
        }
        return 0;
    }

    public akc getNeighborOfBlockHitMaterial() {
        if (this.isBlock()) {
            return this.world.g(this.neighbor_block_x, this.neighbor_block_y, this.neighbor_block_z);
        }
        return null;
    }

    public nn getEntityHit() {
        if (this.isEntity()) {
            return (nn)this.object_hit;
        }
        return null;
    }

    public boolean isBlockHitFullWaterBlock(boolean include_moving_water) {
        if (this.isBlock()) {
            return apc.isFullWaterBlock(this.getBlockHit(), this.block_hit_metadata, include_moving_water);
        }
        return false;
    }

    public boolean isBlockHitFullLavaBlock(boolean include_moving_lava) {
        if (this.isBlock()) {
            return apc.isFullLavaBlock(this.getBlockHit(), this.block_hit_metadata, include_moving_lava);
        }
        return false;
    }

    public boolean isBlockHitReplaceableBy(aqz block, int metadata) {
        if (this.isBlock()) {
            return this.getBlockHit().canBeReplacedBy(this.block_hit_metadata, block, metadata);
        }
        return false;
    }

    public boolean setBlockHitToAir() {
        if (this.world.I) {
            atv.setErrorMessage("setBlockHitToAir: why calling this on client?");
        }
        return this.world.i(this.block_hit_x, this.block_hit_y, this.block_hit_z);
    }

    public boolean isNeighborAirBlock() {
        if (this.isBlock()) {
            return this.world.c(this.neighbor_block_x, this.neighbor_block_y, this.neighbor_block_z);
        }
        atv.setErrorMessage("isNeighborAirBlock: object hit is not block");
        return false;
    }

    public boolean setNeighborBlock(aqz block) {
        if (this.world.I) {
            atv.setErrorMessage("setNeighborBlock: why calling this on client?");
        }
        return this.world.c(this.neighbor_block_x, this.neighbor_block_y, this.neighbor_block_z, block == null ? 0 : block.cF);
    }

    public void playSoundAtNeighborBlock(String name, float volume, float pitch) {
        if (this.world.I) {
            atv.setErrorMessage("playSoundAtNeighborBlock: not meant to be called on client (" + name + ")");
        }
        this.world.playSoundAtBlock(this.neighbor_block_x, this.neighbor_block_y, this.neighbor_block_z, name, volume, pitch);
    }

    public boolean canPlayerMineBlockHit(uf player) {
        if (this.isBlock()) {
            return this.world.a(player, this.block_hit_x, this.block_hit_y, this.block_hit_z);
        }
        atv.setErrorMessage("canPlayerMineBlockHit: object hit is not block");
        return false;
    }

    public boolean canPlayerEditBlockHit(uf player, ye item_stack) {
        if (this.isBlock()) {
            return player.canPlayerEdit(this.block_hit_x, this.block_hit_y, this.block_hit_z, item_stack);
        }
        atv.setErrorMessage("canPlayerEditBlockHit: object hit is not block");
        return false;
    }

    public boolean canPlayerMineNeighborOfBlockHit(uf player) {
        if (this.isBlock()) {
            return this.world.a(player, this.neighbor_block_x, this.neighbor_block_y, this.neighbor_block_z);
        }
        atv.setErrorMessage("canPlayerMineNeighborOfBlockHit: object hit is not block");
        return false;
    }

    public boolean canPlayerEditNeighborOfBlockHit(uf player, ye item_stack) {
        if (this.isBlock()) {
            return player.canPlayerEdit(this.neighbor_block_x, this.neighbor_block_y, this.neighbor_block_z, item_stack);
        }
        atv.setErrorMessage("canPlayerEditNeighborOfBlockHit: object hit is not block");
        return false;
    }

    public double getDistanceFromOriginToCollisionPoint() {
        return this.raycast.getOrigin().d(this.position_hit);
    }

    public String toString() {
        if (this.isEntity()) {
            return this.getEntityHit().an();
        }
        if (this.isBlock()) {
            return this.getBlockHit().A() + " @ " + this.block_hit_x + "," + this.block_hit_y + "," + this.block_hit_z;
        }
        return "Raycast hit other?";
    }
}

